# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 9
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR9_strategy.txt
# LLM Suggested Fallback: C

def velvet_whisperer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Initial Phase: Rounds 1-3
    if current_round <= 3:
        return "C"
    
    # Middle Phase: Rounds 4-7
    elif current_round <= 7:
        early_defects = sum(1 for move in opp_history[:3] if move == "D")
        
        if early_defects >= 2:
            return opp_history[-1] if opp_history else "C"
        else:
            if random.random() < 0.2:
                return "D"
            else:
                return "C"
    
    # Final Phase: Rounds 8-10
    else:
        total_defects = sum(1 for move in opp_history if move == "D")
        
        if "return 'D'" in opponent_program_code or "return 'd'" in opponent_program_code:
            return "D"
        elif total_defects >= 3:
            return opp_history[-1] if opp_history else "C"
        else:
            return "D" if opp_history and opp_history[-1] == "D" else "C"